import flixel.math.FlxRect;
import flixel.text.FlxTextBorderStyle;
import flixel.text.FlxTextAlign;
import flixel.text.FlxTextFormat;
import flixel.text.FlxTextFormatMarkerPair;

// time bar and its texts
var timeBar:FunkinSprite;
var timeBarRect:FlxRect;
var timeBG:FunkinSprite;
var timeBarTxtT:FlxText;
var timeBarTxtB:FlxText;

// rating text :)
var ratingTxt:FlxText;
var ratingTxtTimeout:Int;
var ratingTxtTimeoutTime:Int = 18; // in steps
var rTmarkerFormat:FlxTextFormat = new FlxTextFormat(0xFFFFFFFF);
var rTmarkerPair:FlxTextFormatMarkerPair = new FlxTextFormatMarkerPair(rTmarkerFormat, "[w]");

gameOverSong = 'mm2death';
retrySFX = 'gameover/woodman/deathEnd';
function create()
	importScript("data/scripts/classicNotes");

function postCreate() {
	camFollow.setPosition(dad.getCameraPosition().x, dad.getCameraPosition().y);

	timeBG = new FunkinSprite().loadGraphic(Paths.image('game/hud/mm2/timeBG'));
	timeBG.scale.set(1.5, 1.5);
	timeBG.updateHitbox();
	timeBG.y = FlxG.height - timeBG.height - 40;
	timeBG.screenCenter(FlxAxes.X);
	add(timeBG);

	timeBar = new FunkinSprite(timeBG.x + 3, timeBG.y + 3).loadGraphic(Paths.image('game/hud/mm2/timeBar'));
	timeBar.scale.set(1.5, 1.5);
	timeBar.updateHitbox();
	timeBar.visible = false;
	add(timeBar);

	timeBar.cameras = timeBG.cameras = [camHUD];
	timeBar.scrollFactor.set();
	timeBG.scrollFactor.set();

	timeBarRect = new FlxRect(0, 0, timeBar.width, timeBar.height);
	timeBar.clipRect = timeBarRect;

	PlayState.instance.scoreTxt.visible = PlayState.instance.missesTxt.visible = PlayState.instance.accuracyTxt.visible = PlayState.instance.comboGroup.visible = false;

	trace('song name is ' + PlayState.SONG.meta.name);
	timeBarTxtT = new FlxText(0, 0, 0,
		PlayState.SONG.meta.name + '.mid        health: ' + FlxMath.roundDecimal((PlayState.instance.health / PlayState.instance.maxHealth) * 100, 10));
	timeBarTxtT.setFormat(Paths.font('mensaCondensed.ttf'), 25, 0xFFFFFFFF, FlxTextAlign.LEFT, FlxTextBorderStyle.SHADOW, 0x7D000000);
	timeBarTxtT.setPosition(timeBG.x + 3, timeBG.y - timeBarTxtT.height - 2);
	timeBarTxtT.borderSize = 0.5;
	timeBarTxtT.shadowOffset = FlxPoint.get(3, 3);

	timeBarTxtB = new FlxText(0, 0, 0,
		'score: '
		+ PlayState.instance.songScore
		+ '    accuracy: '
		+ (PlayState.instance.accuracy != -1 ? FlxMath.roundDecimal(PlayState.instance.accuracy * 100, 2) : '0')
		+ '%    misses: '
		+ PlayState.instance.misses);
	timeBarTxtB.setFormat(Paths.font('mensaCondensed.ttf'), 25, 0xFFFFFFFF, FlxTextAlign.LEFT, FlxTextBorderStyle.SHADOW, 0x7D000000);
	timeBarTxtB.setPosition(timeBG.x + 3, timeBG.y + timeBG.height + 2);
	timeBarTxtB.borderSize = 0.5;
	timeBarTxtB.shadowOffset = FlxPoint.get(3, 3);

	add(timeBarTxtT);
	timeBarTxtT.cameras = [camHUD];
	add(timeBarTxtB);
	timeBarTxtB.cameras = [camHUD];

	for (i in [
		PlayState.instance.healthBar,
		PlayState.instance.healthBarBG,
		PlayState.instance.iconP1,
		PlayState.instance.iconP2
	])
		i.visible = false;

	add(ratingTxt = new FlxText(0, 0, 0, ""));
	ratingTxt.cameras = [camHUD];
	ratingTxt.setFormat(Paths.font('mensaCondensed.ttf'), 40, 0xFFFFFFFF, FlxTextAlign.LEFT, FlxTextBorderStyle.SHADOW, 0x7D000000);
	ratingTxt.setPosition(timeBG.x + timeBG.width - ratingTxt.width - 2, timeBG.y - ratingTxt.height - 2);
	ratingTxt.alignment = FlxTextAlign.CENTER;
	ratingTxt.borderSize = 0.5;
	ratingTxt.shadowOffset = FlxPoint.get(3, 3);
}

function beatHit(beat)
	if (beat > 0)
		timeBar.visible = true;

function onPlayerHit(event:NoteHitEvent) {
	if (!event.note.isSustainNote) {
		var funny:String = "";
		var funnyClr:FlxColor = 0x000000;

		switch (event.rating) {
			case 'sick':
				funny = 'nice >:]';
				funnyClr = 0x00FF00;
			case 'good':
				funny = 'neat :>';
				funnyClr = 0x4DB300;
			case 'bad':
				funny = 'eh >:|';
				funnyClr = 0xB14F00;
			case 'shit':
				funny = 'damn >:[';
				funnyClr = 0xD82800;
			default:
				funny = 'youtu.be/YRRgtchGnAk <:[';
				funnyClr = 0xFFFFFF;
		}
		ratingTxt.text = funny + " [w]" + (PlayState.instance.combo + 1) + "[w]";
		ratingTxt.applyMarkup(ratingTxt.text, [rTmarkerPair]);
		ratingTxt.color = funnyClr;
		ratingTxt.x = timeBG.x + timeBG.width - ratingTxt.width - 2;

		ratingTxt.scale.set(1.5, 0.9);
		// FlxTween.cancelTweensOf(ratingTxt.scale);
		// FlxTween.tween(ratingTxt.scale, {x: 1, y: 1}, 0.5, {ease: FlxEase.expoOut});
	}

	FlxTween.cancelTweensOf(ratingTxt);
	ratingTxt.alpha = 1;
	ratingTxtTimeout = ratingTxtTimeoutTime;
}

function onPlayerMiss(event:NoteHitEvent) {
	ratingTxt.text = "miss <:[ 0";
	ratingTxt.color = 0xFF0000;
	ratingTxt.x = timeBG.x + timeBG.width - ratingTxt.width - 2;

	ratingTxt.scale.set(0.8, 0.8);
	// FlxTween.cancelTweensOf(ratingTxt.scale);
	// FlxTween.tween(ratingTxt.scale, {x: 1, y: 1}, 0.5, {ease: FlxEase.expoOut});

	FlxTween.cancelTweensOf(ratingTxt);
	ratingTxt.alpha = 1;
	ratingTxtTimeout = ratingTxtTimeoutTime;
}

var timer:Float = 0;
var ratingTimer:Float = 0;
var range;

function update(elapsed) {
	timer += elapsed;
	if (timer >= 0.25) {
		updateTimebar();
		timer = 0;
	}

	if (curStep < 1904) // dont update while woodman is moving!!
		range = [dad.getCameraPosition(), boyfriend.getCameraPosition()];

	var hp = FlxMath.bound(FlxMath.roundDecimal((PlayState.instance.health / PlayState.instance.maxHealth) * 100, 0), 0, 100);

	if (timeBarTxtT != null)
		timeBarTxtT.text = PlayState.SONG.meta.name + '.mid        health: ' + hp + '%';
	if (timeBarTxtB != null && FlxG.sound.music != null && (FlxG.sound.music.time != null && FlxG.sound.music.length != null))
		timeBarTxtB.text = 'score: '
			+ PlayState.instance.songScore
			+ '    accuracy: '
			+ (PlayState.instance.accuracy != -1 ? FlxMath.roundDecimal(PlayState.instance.accuracy * 100, 2) : '0')
			+ '%    misses: '
			+ PlayState.instance.misses;

	ratingTxt.scale.set(FlxMath.lerp(ratingTxt.scale.x, 1, 0.25), FlxMath.lerp(ratingTxt.scale.y, 1, 0.25));
}

function updateTimebar() {
	if (FlxG.sound.music != null) {
		var len = FlxMath.roundDecimal(FlxG.sound.music.time / FlxG.sound.music.length, 5);

		timeBarRect.width = (timeBar.width * len) / 1.5; // why does this work when i do /1.5 ??????   ~xavi.
		timeBar.clipRect = timeBarRect;
	}
}

function stepHit(step) {
	if (ratingTxtTimeout > 0)
		ratingTxtTimeout--;

	if (ratingTxtTimeout == 0) {
		FlxTween.tween(ratingTxt, {alpha: 0}, 0.3, {ease: FlxEase.circInOut});
	}
}
